#!/bin/sh
# resolve links - $0 may be a softlink
PRG=`readlink -f $0`

while [ -h "$PRG" ] ; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

VARSDIR=`dirname "$PRG"`

. $VARSDIR/vars.sh

JAVA_OPTS="-cp $AVJCEPROV_HOME/avocspclient.jar:$AVCLASSPATH $AV_JAVA_OPTS -Dby.avest.crypto.ocsp.client.tolerance=60,60"
AVOCSPCLIENT_CLASS=by.avest.crypto.ocsp.client.tools.OCSPClientTool

"$JAVA_EXE" $JAVA_OPTS $AVOCSPCLIENT_CLASS "$@" -debug
