#!/bin/sh
export AVJCEPROV_HOME=/opt/AvJCEProv

AVJCEPROV_LIB="$AVJCEPROV_HOME"

AVCLASSPATH=\
$AVJCEPROV_LIB/avjavasecprov-shared.jar:\
$AVJCEPROV_LIB/avjceprovlib-avbign-shared.jar:\
$AVJCEPROV_LIB/avjceprovlib-avhsm-shared.jar:\
$AVJCEPROV_LIB/avjceprovlib-avtoken-shared.jar:\
$AVJCEPROV_LIB/avjavasecprovintf.jar:\
$AVJCEPROV_LIB/avoids.jar:\
$AVJCEPROV_LIB/avtlsjava-bign.jar:\
$AVJCEPROV_LIB/avjavaseckit.jar:\
$AVJCEPROV_LIB/avocspclient.jar:\
$AVJCEPROV_LIB/avtsc.jar:\
$AVJCEPROV_LIB/avjutils.jar:\
$AVJCEPROV_LIB/avlog.jar:\
$AVJCEPROV_LIB/avpkitools.jar:\
$AVJCEPROV_LIB/avstores.jar:\
$AVJCEPROV_LIB/avhsmprovider.jar:\
$AVJCEPROV_LIB/avtokenprovider.jar:\
$AVJCEPROV_LIB/avbignprovider.jar

#AV_RDEBUG="-Xdebug -Xrunjdwp:transport=dt_socket,address=7071,server=y,suspend=n"
#AV_DEBUG="-Djava.security.debug=nativeloader,avjceprov,avtoken,avbign,avhsm,avtls,avstores,avuniversal,avdemo -Djavax.net.debug=trustmanager $AV_RDEBUG"
AV_JAVA_OPTS="$AV_DEBUG"

if [ "$AV_JAVA_HOME" = "" ]; then
	AV_JAVA_HOME="$JAVA_HOME"
fi

if [ "$AV_JAVA_HOME" = "" ]; then
	AV_JAVA_HOME="$JRE_HOME"
fi

export AV_JAVA_HOME

if [ ! -f "$AVJCEPROV_LIB/avjavasecprov-shared.jar" ]; then
	echo "ERROR: Core provider file \"$AVJCEPROV_LIB/avjavasecprov-shared.jar\" not found."
	kill $$
	exit
fi

JAVA_EXE="$AV_JAVA_HOME/bin/java"
if [ ! -f "$JAVA_EXE" ]; then
	JAVA_EXE=java
fi

( "$JAVA_EXE" -version 2>&1 | grep -Eq ".*64\-Bit" ) && AVJCEPROV_LIB_NATIVE="$AVJCEPROV_LIB/linux64" || AVJCEPROV_LIB_NATIVE="$AVJCEPROV_LIB/linux32"

export LD_LIBRARY_PATH=$AVJCEPROV_LIB_NATIVE
AV_JAVA_OPTS="$AV_JAVA_OPTS -Djava.library.path=\"$AVJCEPROV_LIB_NATIVE\""

if [ ! -d "$AVJCEPROV_LIB_NATIVE" ]; then
	echo "ERROR: Native library folder \"$AVJCEPROV_LIB_NATIVE\" not found. Java executable from environment \"$JAVA_EXE\""
	kill $$
	exit
fi

export AVCLASSPATH
export AV_JAVA_OPTS
export JAVA_EXE
