@echo off
setlocal enabledelayedexpansion

set "avcspbelDirectory=%ProgramFiles(x86)%\Avest\Avest CSP Bel"
if not exist "!avcspbelDirectory!" (
    set "avcspbelDirectory=%ProgramFiles%\Avest\Avest CSP Bel"
    if not exist "!avcspbelDirectory!" (
        echo Error: Directory not found: "!avcspbelDirectory!"
    )
)

set "targetFile=AvCSPBEL_*.pdf"

call :DeleteFilesBasedOnPattern avcspbelDirectory targetFile

endlocal
echo Script execution completed.
exit /b

rem Function to delete files based on file pattern
:DeleteFilesBasedOnPattern
    set "directory=!%1!"
    set "filePattern=!%2!"
    echo Checking and deleting files in !directory! based on pattern...

    set "fileNotFound=true"
    for /f "delims=" %%i in ('dir /b /a-d "!directory!\!filePattern!"  2^>nul') do (
        set "fileToDelete=!directory!\%%i"
        echo Deleting file: !fileToDelete!
        del "!fileToDelete!" 2>nul && (
            echo File deleted successfully.
        ) || (
            echo An error occurred while deleting file: !fileToDelete!
        )
        set "fileNotFound=false"
    )

    if "!fileNotFound!"=="true" (
        echo No files matching pattern !filePattern! found in the specified directory.
    )
    exit /b

