@echo off
chcp 1251

set "targetDirectory=%userprofile%\Desktop"
if not exist "%targetDirectory%" (
    set "targetDirectory=%userprofile%\ "
)

set "targetPath=%ProgramFiles%\Avest\AvPCM_nces\get_crl.bat"
if not exist "%targetPath%" (
    set "targetPath=%ProgramFiles(x86)%\Avest\AvPCM_nces\get_crl.bat"
)

echo Checking shortcuts in %targetDirectory%...

if not exist "%targetDirectory%\*.lnk" (
    echo No shortcuts found in the specified directory.
) else (
    rem Create the VBScript file for deleting shortcuts
    (
        echo Set objShell = CreateObject^("WScript.Shell"^)
        echo Set lnk = objShell.CreateShortcut^(WScript.Arguments^(0^)^)
        echo WScript.Echo lnk.TargetPath
    ) > gettarget.vbs

    for %%I in ("%targetDirectory%\*.lnk") do (
        setlocal enabledelayedexpansion
        set "shortcutTarget="
        for /f "tokens=*" %%A in ('cscript //Nologo gettarget.vbs "%%~fI"') do (
            set "shortcutTarget=%%A"
        )
        echo Checking shortcut: %%I
        echo Target of the shortcut: !shortcutTarget!
        if /i "!shortcutTarget!"=="%targetPath%" (
            echo Deleting shortcut: %%I
            del "%%I"
            echo Shortcut deleted successfully.
        ) else (
            echo The target of this shortcut does not match the specified path.
        )
        endlocal
    )

    rem Delete the temporary VBScript file
    del gettarget.vbs /q
)


setlocal enabledelayedexpansion

set "avpcmDirectory=%ProgramFiles%\Avest\AvPCM_nces"
if not exist "!avpcmDirectory!" (
    set "avpcmDirectory=%ProgramFiles(x86)%\Avest\AvPCM_nces"
    if not exist "!avpcmDirectory!" (
        echo Error: Directory not found: "!avpcmDirectory!"
    )
)

set "targetFile1=get_crl.bat"
set "targetFile2=wget.exe"
set "targetFile3=AvUCK_*.pdf"

call :DeleteSpecificFiles avpcmDirectory targetFile1
call :DeleteSpecificFiles avpcmDirectory targetFile2
call :DeleteFilesBasedOnPattern avpcmDirectory targetFile3

endlocal
echo Script execution completed.
exit /b

rem Function to delete specific files based on their names
:DeleteSpecificFiles
    set "directory=!%1!"
    set "fileNames=!%2!"
    echo Checking and deleting specific files in !directory!...

    for %%i in (!fileNames!) do (
        set "fileToDelete=!directory!\%%i"
        if exist "!fileToDelete!" (
            echo Deleting file: !fileToDelete!
            del "!fileToDelete!" 2>nul && (
                echo File deleted successfully.
            ) || (
                echo An error occurred while deleting file: !fileToDelete!
            )
        ) else (
            echo File !fileToDelete! does not exist in the specified directory.
        )
    )
    exit /b

rem Function to delete files based on file pattern
:DeleteFilesBasedOnPattern
    set "directory=!%1!"
    set "filePattern=!%2!"
    echo Checking and deleting files in !directory! based on pattern...

    set "fileNotFound=true"
    for /f "delims=" %%i in ('dir /b /a-d "!directory!\!filePattern!"  2^>nul') do (
        set "fileToDelete=!directory!\%%i"
        echo Deleting file: !fileToDelete!
        del "!fileToDelete!" 2>nul && (
            echo File deleted successfully.
        ) || (
            echo An error occurred while deleting file: !fileToDelete!
        )
        set "fileNotFound=false"
    )

    if "!fileNotFound!"=="true" (
        echo No files matching pattern !filePattern! found in the specified directory.
    )
    exit /b
